mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_texture_path (current_mod_path.."/Textures/cargo_container.zip")

GT = {};
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_stationary)
set_recursive_metatable(GT.chassis, GT_t.CH_t.STATIC);
GT.chassis.life = 250

-- intact + destroyed models
GT.visual.shape     = "cargo_container"
GT.visual.shape_dstr = "cargo_container_destroyed"
GT.CustomAimPoint = {1,1,0}

-- Burning after hit
GT.visual.fire_size = 0.5 -- relative burning size
GT.visual.fire_pos = {0,4,0}
GT.visual.fire_time = 180 -- burning time (seconds)
GT.canExplode = true
GT.visual.min_time_agony = 1
GT.visual.max_time_agony = 3

-- shape table: intact + destroyed versions
GT.shape_table_data = {
    {
        file   = "cargo_container",          -- intact model
        life   = 5,                          -- HP value (non-zero)
        desrt  = "cargo_container_destroyed",-- destroyed reference
        fire   = { 0, 1 },                   -- fire size/lifetime
        username = "Cargo Container",
        classname = "lLandVehicle",
        positioning = "BYNORMAL",
    },
    {
        name  = "cargo_container_destroyed", -- must match GT.visual.shape_dstr
        file  = "cargo_container_destroyed", -- destroyed model filename
        life  = 999,                         -- wreckage life (stays around)
    },
}

GT.sensor = {}
set_recursive_metatable(GT.sensor, GT_t.SN_visual)
GT.sensor.height = 2.0
GT.sensor.max_range_finding_target = 1000

local __LN_PK = {}
set_recursive_metatable(__LN_PK, GT_t.LN_t.machinegun_7_62)
__LN_PK.connectorFire = false
__LN_PK.distanceMax = 800
for i=2,10 do -- 1000 rnds
    __LN_PK.PL[i] = {}
    set_recursive_metatable(__LN_PK.PL[i], __LN_PK.PL[1])
end
__LN_PK.BR[1].pos = {1,0,0}

GT.WS = {}
GT.WS.maxTargetDetectionRange = 2000

local ws = 0
for i=1,4 do 
  ws = GT_t.inc_ws()
  GT.WS[ws] = {}
  GT.WS[ws].maxBottom = math.rad(-15)
  GT.WS[ws].maxTop = math.rad(45)
  GT.WS[ws].angles = {
      {math.rad(180), math.rad(-180), math.rad(-15), math.rad(45)},
  }
  GT.WS[ws].omegaY = math.rad(120)
  GT.WS[ws].omegaZ = math.rad(120)
  GT.WS[ws].pidY = {p=10,i=0.05,d=2,inn=3}
  GT.WS[ws].pidZ = {p=10,i=0.05,d=2,inn=3}

  __LN = add_launcher(GT.WS[ws], __LN_PK)
end 

GT.WS[1].pos = {1,1.5,1}
GT.WS[1].maxLeft = math.rad(55)
GT.WS[1].maxRight = math.rad(-55)
GT.WS[1].angles[1][1] = math.rad(55)
GT.WS[1].angles[1][2] = math.rad(-55)

GT.WS[2].pos = {-13,1.5,0}
GT.WS[2].maxLeft = math.rad(-125)
GT.WS[2].maxRight = math.rad(125)
GT.WS[2].angles[1][1] = math.rad(-125)
GT.WS[2].angles[1][2] = math.rad(125)
GT.WS[2].reference_angle_Y = math.rad(180)

GT.WS[3].pos = {0,1.5,-20}
GT.WS[3].maxLeft = math.rad(145)
GT.WS[3].maxRight = math.rad(35)
GT.WS[3].angles[1][1] = math.rad(145)
GT.WS[3].angles[1][2] = math.rad(35)
GT.WS[3].reference_angle_Y = math.rad(90)

GT.WS[4].pos = {0,1.5,20}
GT.WS[4].maxLeft = math.rad(-35)
GT.WS[4].maxRight = math.rad(-145)
GT.WS[4].angles[1][1] = math.rad(-35)
GT.WS[4].angles[1][2] = math.rad(-145)
GT.WS[4].reference_angle_Y = math.rad(-90)

GT.Name = "cargo_container"
GT.DisplayName = _("cargo container")
GT.Rate = 5

GT.DetectionRange  = 0
GT.ThreatRange = GT.WS[1].LN[1].distanceMax
GT.mapclasskey = "P0091000076"
GT.attribute = {wsType_Ground,wsType_Tank,wsType_Gun,wsType_GenericFort,
                "Fortifications"}
GT.category = "Fortification"

add_surface_unit(GT)
